/**
 * This module is the highest level module for the calendar. It is
 * responsible for initialising all of the components required for
 * the calendar to run. It also coordinates the interaction between
 * components by listening for and responding to different events
 * triggered within the calendar UI.
 *
 * @module     core_calendar/calendar_mini
 * @copyright  2017 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_calendar/calendar_mini",["jquery","core_calendar/selectors","core_calendar/events","core_calendar/view_manager"],(function($,CalendarSelectors,CalendarEvents,CalendarViewManager){var reloadMonth=function(e){var root=e.data,body=$("body"),namespace="."+root.attr("id");root.is(":visible")?CalendarViewManager.reloadCurrentMonth(root):(body.off(CalendarEvents.created+namespace),body.off(CalendarEvents.deleted+namespace),body.off(CalendarEvents.updated+namespace),body.off(CalendarEvents.eventMoved+namespace))};return{init:function(root,loadOnInit){root=$(root),CalendarViewManager.init(root),function(root){$("body").on(CalendarEvents.filterChanged,(function(e,data){root.find(CalendarSelectors.eventType[data.type]).toggleClass("calendar_event_"+data.type,!data.hidden)}));var namespace="."+root.attr("id");$("body").on("change"+namespace,CalendarSelectors.elements.courseSelector,(function(){if(root.is(":visible")){var courseId=$(this).val();CalendarViewManager.reloadCurrentMonth(root,courseId,null)}else $("body").off("change"+namespace)}))}(root),function(root){var body=$("body"),namespace="."+root.attr("id");body.on(CalendarEvents.created+namespace,root,reloadMonth),body.on(CalendarEvents.deleted+namespace,root,reloadMonth),body.on(CalendarEvents.updated+namespace,root,reloadMonth),body.on(CalendarEvents.eventMoved+namespace,root,reloadMonth)}(root),loadOnInit&&CalendarViewManager.reloadCurrentMonth(root)}}}));

//# sourceMappingURL=calendar_mini.min.js.map