/**
 * Controls the message drawer.
 *
 * @module     core_message/message_drawer
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer",["jquery","core/custom_interaction_events","core/pubsub","core_message/message_drawer_view_contact","core_message/message_drawer_view_contacts","core_message/message_drawer_view_conversation","core_message/message_drawer_view_group_info","core_message/message_drawer_view_overview","core_message/message_drawer_view_search","core_message/message_drawer_view_settings","core_message/message_drawer_router","core_message/message_drawer_routes","core_message/message_drawer_events","core_message/message_drawer_helper","core/pending","core/drawer","core/toast","core/str","core/config","core/ajax","core/local/aria/focuslock","core/modal_backdrop","core/templates","core/local/aria/selectors"],(function($,CustomEvents,PubSub,ViewContact,ViewContacts,ViewConversation,ViewGroupInfo,ViewOverview,ViewSearch,ViewSettings,Router,Routes,Events,Helper,Pending,Drawer,Toast,Str,Config,Ajax,FocusLock,ModalBackdrop,Templates,AriaSelectors){var SELECTORS={DRAWER:'[data-region="right-hand-drawer"]',PANEL_BODY_CONTAINER:'[data-region="panel-body-container"]',PANEL_HEADER_CONTAINER:'[data-region="panel-header-container"]',VIEW_CONTACT:'[data-region="view-contact"]',VIEW_CONTACTS:'[data-region="view-contacts"]',VIEW_CONVERSATION:'[data-region="view-conversation"]',VIEW_CONVERSATION_WITH_ID:'[data-region="view-conversation"][data-conversation-id]',VIEW_CONVERSATION_WITH_USER:'[data-region="view-conversation"][data-other-user-id]',VIEW_GROUP_INFO:'[data-region="view-group-info"]',VIEW_OVERVIEW:'[data-region="view-overview"]',VIEW_SEARCH:'[data-region="view-search"]',VIEW_SETTINGS:'[data-region="view-settings"]',ROUTES:"[data-route]",ROUTES_BACK:"[data-route-back]",HEADER_CONTAINER:'[data-region="header-container"]',BODY_CONTAINER:'[data-region="body-container"]',FOOTER_CONTAINER:'[data-region="footer-container"]',CLOSE_BUTTON:'[data-action="closedrawer"]',MESSAGE_INDEX:'[data-region="message-index"]',MESSAGE_TEXT_AREA:'[data-region="send-message-txt"]'},routes=[[Routes.VIEW_CONTACT,SELECTORS.VIEW_CONTACT,ViewContact.show,ViewContact.description],[Routes.VIEW_CONTACTS,SELECTORS.VIEW_CONTACTS,ViewContacts.show,ViewContacts.description],[Routes.VIEW_CONVERSATION,SELECTORS.VIEW_CONVERSATION,ViewConversation.show,ViewConversation.description],[Routes.VIEW_GROUP_INFO,SELECTORS.VIEW_GROUP_INFO,ViewGroupInfo.show,ViewGroupInfo.description],[Routes.VIEW_OVERVIEW,SELECTORS.VIEW_OVERVIEW,ViewOverview.show,ViewOverview.description],[Routes.VIEW_SEARCH,SELECTORS.VIEW_SEARCH,ViewSearch.show,ViewSearch.description],[Routes.VIEW_SETTINGS,SELECTORS.VIEW_SETTINGS,ViewSettings.show,ViewSettings.description]],createRoutes=function(namespace,root){routes.forEach((function(route){Router.add(namespace,route[0],function(namespace,root,selector){var header=root.find(SELECTORS.HEADER_CONTAINER).find(selector);header.length||(header=root.find(SELECTORS.PANEL_HEADER_CONTAINER).find(selector));var body=root.find(SELECTORS.BODY_CONTAINER).find(selector);body.length||(body=root.find(SELECTORS.PANEL_BODY_CONTAINER).find(selector));var footer=root.find(SELECTORS.FOOTER_CONTAINER).find(selector);return[namespace,header.length?header:null,body.length?body:null,footer.length?footer:null]}(namespace,root,route[1]),route[2],route[3])}))};let backdropPromise=null;var setFocus=function(root,hasFocus){var drawerRoot=Drawer.getDrawerRoot(root);if(!drawerRoot.length)return;backdropPromise||(backdropPromise=Templates.render("core/modal_backdrop",{}).then((html=>new ModalBackdrop(html))));const backdropWithAdjustments=backdropPromise.then((modalBackdrop=>{const messageDrawerZIndex=window.getComputedStyle(drawerRoot[0]).zIndex;return messageDrawerZIndex&&modalBackdrop.setZIndex(messageDrawerZIndex-1),modalBackdrop.getAttachmentPoint().get(0).addEventListener("click",(e=>{PubSub.publish(Events.HIDE,{}),e.preventDefault()})),modalBackdrop}));hasFocus?(FocusLock.trapFocus(root[0]),backdropWithAdjustments.then((modalBackdrop=>{if(modalBackdrop){modalBackdrop.show();document.getElementById("page").style.overflow="hidden";var closeButton=root.find(SELECTORS.CLOSE_BUTTON);closeButton.length&&closeButton.focus()}return modalBackdrop}))):backdropWithAdjustments.then((modalBackdrop=>{if(modalBackdrop){FocusLock.untrapFocus();var button=$(SELECTORS.DRAWER).attr("data-origin");button&&$("#"+button).focus(),modalBackdrop.hide();document.getElementById("page").style.overflow="visible"}return modalBackdrop}))},show=function(namespace,root){root.attr("data-shown")||(Router.go(namespace,Routes.VIEW_OVERVIEW),root.attr("data-shown",!0));var drawerRoot=Drawer.getDrawerRoot(root);drawerRoot.length&&(setFocus(root,!0),Drawer.show(drawerRoot))},hide=function(root){var drawerRoot=Drawer.getDrawerRoot(root);drawerRoot.length&&(setFocus(root,!1),Drawer.hide(drawerRoot))},isVisible=function(root){var drawerRoot=Drawer.getDrawerRoot(root);return!drawerRoot.length||Drawer.isVisible(drawerRoot)},setJumpFrom=function(buttonid){$(SELECTORS.DRAWER).attr("data-origin",buttonid)};const storeUnsentMessage=async()=>{const messageTextArea=document.querySelector(SELECTORS.MESSAGE_TEXT_AREA);if(messageTextArea.value.trim().length>0&&!messageTextArea.hasAttribute("data-unsent-message-viewed")){let message=messageTextArea.value,conversationid=0,otheruserid=0;if(document.querySelector(SELECTORS.VIEW_CONVERSATION_WITH_ID)){conversationid=messageTextArea.closest(SELECTORS.VIEW_CONVERSATION_WITH_ID).getAttribute("data-conversation-id")}if(document.querySelector(SELECTORS.VIEW_CONVERSATION_WITH_USER)){otheruserid=messageTextArea.closest(SELECTORS.VIEW_CONVERSATION_WITH_USER).getAttribute("data-other-user-id")}setStoredUnsentMessage(message,conversationid,otheruserid)}},setStoredUnsentMessage=(message,conversationid,otheruserid)=>{const method="core_message_set_unsent_message",requestUrl=new URL("".concat(Config.wwwroot,"/lib/ajax/service.php"));requestUrl.searchParams.set("sesskey",Config.sesskey),requestUrl.searchParams.set("info",method),navigator.sendBeacon(requestUrl,JSON.stringify([{index:0,methodname:method,args:{message:message,conversationid:conversationid,otheruserid:otheruserid}}]))},getUnsentMessage=async(uniqueId,root)=>{let type,messageRoot;if(null!==document.querySelector(SELECTORS.MESSAGE_INDEX)){if(type="index",messageRoot=document.getElementById("message-index-".concat(uniqueId)),!messageRoot)return}else type="drawer",messageRoot=document.getElementById("message-drawer-".concat(uniqueId));const storedMessage=await Ajax.call([{methodname:"core_message_get_unsent_message",args:{}}])[0],messageTextArea=messageRoot.querySelector(SELECTORS.MESSAGE_TEXT_AREA);storedMessage.message&&null!==messageTextArea&&showUnsentMessage(messageTextArea,storedMessage,type,uniqueId,root)},showUnsentMessage=(textArea,stored,type,uniqueId,root)=>{if(!textArea.hasAttribute("data-unsent-message-viewed")){switch(type){case"index":stored.conversationid?Router.go(uniqueId,Routes.VIEW_CONVERSATION,stored.conversationid,"frompanel"):stored.otheruserid&&Router.go(uniqueId,Routes.VIEW_CONVERSATION,null,"create",stored.otheruserid);break;case"drawer":if(stored.conversationid){let args={conversationid:stored.conversationid};Helper.showConversation(args)}else stored.otheruserid&&(show(uniqueId,root),Router.go(uniqueId,Routes.VIEW_CONVERSATION,null,"create",stored.otheruserid))}textArea.value=stored.message,textArea.setAttribute("data-unsent-message-viewed",1),Toast.add(Str.get_string("unsentmessagenotification","core_message"))}};return{init:function(root,uniqueId,alwaysVisible,route){if(root=$(root),createRoutes(uniqueId,root),function(namespace,root,alwaysVisible){CustomEvents.define(root,[CustomEvents.events.activate,CustomEvents.events.escape]);var paramRegex=/^data-route-param-?(\d*)$/;root.on(CustomEvents.events.activate,SELECTORS.ROUTES,(function(e,data){for(var element=$(e.target).closest(SELECTORS.ROUTES),route=element.attr("data-route"),attributes=[],i=0;i<element[0].attributes.length;i++)attributes.push(element[0].attributes[i]);var paramAttributes=attributes.filter((function(attribute){var name=attribute.nodeName;return paramRegex.test(name)}));paramAttributes.sort((function(a,b){var aParts=paramRegex.exec(a.nodeName),bParts=paramRegex.exec(b.nodeName),aIndex=aParts.length>1?aParts[1]:0,bIndex=bParts.length>1?bParts[1]:0;return aIndex<bIndex?-1:bIndex<aIndex?1:0}));var params=paramAttributes.map((function(attribute){return attribute.nodeValue})),routeParams=[namespace,route].concat(params);Router.go.apply(null,routeParams),data.originalEvent.preventDefault()})),root.on(CustomEvents.events.activate,SELECTORS.ROUTES_BACK,(function(e,data){Router.back(namespace),data.originalEvent.preventDefault()})),$(document).on(CustomEvents.events.activate,(e=>{var _$,drawer=$(e.target).closest(SELECTORS.DRAWER),toggleButtonId=null===(_$=$(SELECTORS.DRAWER))||void 0===_$?void 0:_$.attr("data-origin"),toggleButton="";if(void 0!==toggleButtonId&&toggleButtonId&&(toggleButton=$(e.target).closest("#"+toggleButtonId)),!drawer.length&&!toggleButton.length&&isVisible(root)){var focusableElement=$(e.target).closest(AriaSelectors.elements.focusable);focusableElement.length&&$(SELECTORS.DRAWER).attr("data-origin",""),hide(root),focusableElement.length&&focusableElement.focus()}})),root[0].querySelectorAll(".collapse").forEach((collapse=>{collapse.addEventListener("hide.bs.collapse",(e=>{var pendingPromise=new Pending;e.target.addEventListener("hidden.bs.collapse",(function(){pendingPromise.resolve()}),{once:!0})}))})),root[0].querySelectorAll(".collapse").forEach((collapse=>{collapse.addEventListener("show.bs.collapse",(e=>{var pendingPromise=new Pending;e.target.addEventListener("shown.bs.collapse",(function(){pendingPromise.resolve()}),{once:!0})}))})),$(SELECTORS.JUMPTO).focus((function(){var firstInput=root.find(SELECTORS.CLOSE_BUTTON);firstInput.length?firstInput.focus():$(SELECTORS.HEADER_CONTAINER).find(SELECTORS.ROUTES_BACK).focus()})),$(SELECTORS.DRAWER).focus((function(){var button=$(this).attr("data-origin");button&&$("#"+button).focus()})),alwaysVisible||(PubSub.subscribe(Events.SHOW,(function(){show(namespace,root)})),PubSub.subscribe(Events.HIDE,(function(){hide(root)})),PubSub.subscribe(Events.TOGGLE_VISIBILITY,(function(buttonid){const buttonElement=document.getElementById(buttonid);isVisible(root)?(hide(root),null==buttonElement||buttonElement.setAttribute("aria-expanded",!1),$(SELECTORS.JUMPTO).attr("tabindex",-1)):(show(namespace,root),null==buttonElement||buttonElement.setAttribute("aria-expanded",!0),setJumpFrom(buttonid),$(SELECTORS.JUMPTO).attr("tabindex",0))})),root.on(CustomEvents.events.escape,(function(){PubSub.publish(Events.HIDE,{})}))),PubSub.subscribe(Events.SHOW_CONVERSATION,(function(args){setJumpFrom(args.buttonid),show(namespace,root),Router.go(namespace,Routes.VIEW_CONVERSATION,args.conversationid)})),root.find(SELECTORS.CLOSE_BUTTON).on(CustomEvents.events.activate,(function(e,data){data.originalEvent.preventDefault(),setFocus(root,!1);var button=$(SELECTORS.DRAWER).attr("data-origin");button&&$("#"+button).focus(),PubSub.publish(Events.TOGGLE_VISIBILITY,button)})),PubSub.subscribe(Events.CREATE_CONVERSATION_WITH_USER,(function(args){setJumpFrom(args.buttonid),show(namespace,root),Router.go(namespace,Routes.VIEW_CONVERSATION,null,"create",args.userid)})),PubSub.subscribe(Events.SHOW_SETTINGS,(function(){show(namespace,root),Router.go(namespace,Routes.VIEW_SETTINGS)})),PubSub.subscribe(Events.PREFERENCES_UPDATED,(function(preferences){var filteredPreferences=preferences.filter((function(preference){return"message_entertosend"==preference.type})),enterToSendPreference=filteredPreferences.length?filteredPreferences[0]:null;enterToSendPreference&&root.find(SELECTORS.FOOTER_CONTAINER).find(SELECTORS.VIEW_CONVERSATION).attr("data-enter-to-send",enterToSendPreference.value)}));const textArea=document.querySelector(SELECTORS.MESSAGE_TEXT_AREA);textArea&&textArea.addEventListener("keyup",(function(){textArea.removeAttribute("data-unsent-message-viewed")})),window.addEventListener("beforeunload",storeUnsentMessage)}(uniqueId,root,alwaysVisible),alwaysVisible&&(show(uniqueId,root),route)){var routeParams=route.params||[];routeParams=[uniqueId,route.path].concat(routeParams),Router.go.apply(null,routeParams)}Helper.markDrawerReady(),getUnsentMessage(uniqueId,root)}}}));

//# sourceMappingURL=message_drawer.min.js.map